# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 3
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR3_strategy.txt
# LLM Suggested Fallback: C

def harmonic_trust_builder(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    total_rounds = len(my_history) + 1
    last_opp_move = opp_history[-1]
    
    # Detect naive patterns in opponent's code
    always_c = "return 'c'" in opponent_program_code.lower() or "always cooperate" in opponent_program_code.lower()
    always_d = "return 'd'" in opponent_program_code.lower() or "always defect" in opponent_program_code.lower()
    
    if always_c:
        return "D"
    if always_d:
        return "C" if total_rounds <= 5 else "D"
    
    # Calculate opponent's cooperation rate
    opp_coop_rate = opp_history.count("C") / len(opp_history)
    
    # Tit-for-Tat with forgiveness
    if last_opp_move == "D":
        return "D"
    elif last_opp_move == "C":
        if total_rounds >= 8 and opp_coop_rate > 0.7:
            return "D"
        return "C"
    
    return "C"